import UIKit

class ViewController: UIViewController
{

    @IBOutlet weak var myLabel: UILabel!
    
    override func viewDidLoad()
    {
        super.viewDidLoad()
        
        
        myLabel.layer.cornerRadius = 25.0
        myLabel.layer.borderWidth = 5.0
        myLabel.layer.borderColor = UIColor.blue.cgColor
        myLabel.clipsToBounds = true
        
        let subLayer = CALayer()
        subLayer.frame = myLabel.bounds.insetBy(dx: 30,
                                                dy: 30)
        
        subLayer.backgroundColor = UIColor.green.cgColor
        subLayer.shadowOffset = CGSize(width: 10, height: 10)
        subLayer.shadowRadius = 2.0
        subLayer.shadowColor = UIColor.black.cgColor
        subLayer.shadowOpacity = 0.6
        subLayer.cornerRadius = 20.0
        myLabel.layer.addSublayer(subLayer)
        
        
        
    }


}

